//
//  Animating_and_Rotating_ViewsViewController.m
//  Animating and Rotating Views
//
//  Created by Vandad Nahavandipoor on 17/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Animating_and_Rotating_ViewsViewController.h"

@implementation Animating_and_Rotating_ViewsViewController

@synthesize xcodeImageView;

- (void) viewDidLoad{
  [super viewDidLoad];
  
  UIImage *xcodeImage = [UIImage imageNamed:@"Xcode.png"];
  
  self.xcodeImageView = [[UIImageView alloc]
                         initWithImage:xcodeImage];
  
  /* Ustawiamy mniejsze wymiary obrazu. */
  [self.xcodeImageView setFrame:CGRectMake(0.0f,
                                           0.0f,
                                           100.0f,
                                           100.0f)];
  
  self.view.backgroundColor = [UIColor whiteColor];
  [self.view addSubview:self.xcodeImageView];
  
}

- (void)clockwiseRotationStopped:(NSString *)paramAnimationID
                        finished:(NSNumber *)paramFinished
                         context:(void *)paramContext{
  
  [UIView beginAnimations:@"counterclockwiseAnimation"
                  context:NULL];
  
  /* Animacja trwa pięć sekund. */
  [UIView setAnimationDuration:5.0f];
  
  /* Powrót obrazu do położenia początkowego. */
  self.xcodeImageView.transform = CGAffineTransformIdentity;
  
  [UIView commitAnimations];
  
}

- (void) viewDidAppear:(BOOL)paramAnimated{
  [super viewDidAppear:paramAnimated];
  
  self.xcodeImageView.center = self.view.center;
  
  /* Rozpoczęcie animacji. */
  [UIView beginAnimations:@"clockwiseAnimation"
                  context:NULL];
  
  /* Animacja trwa pięć sekund. */
  [UIView setAnimationDuration:5.0f];
  
  [UIView setAnimationDelegate:self];
  
  [UIView setAnimationDidStopSelector:
   @selector(clockwiseRotationStopped:finished:context:)];
  
  /* Obrót widoku obrazu o 90 stopni. */
  self.xcodeImageView.transform =
  CGAffineTransformMakeRotation((90.0f * M_PI) / 180.0f);
  
  /* Zatwierdzenie animacji. */
  [UIView commitAnimations];
  
}

- (void)viewDidUnload{
  [super viewDidUnload];
  self.xcodeImageView = nil;
}

- (BOOL)shouldAutorotateToInterfaceOrientation
        :(UIInterfaceOrientation)interfaceOrientation{
  return YES;
}

@end
